/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.api.common.data;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IKillData;
import dev.toma.gunsrpg.api.common.data.ILockStateChangeable;
import dev.toma.gunsrpg.api.common.skill.ITransactionValidator;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.skills.core.TransactionValidatorRegistry;
import dev.toma.gunsrpg.common.skills.core.WeaponTransactionValidator;
import dev.toma.gunsrpg.resource.progression.FakeLevelingStrategy;
import dev.toma.gunsrpg.resource.progression.IProgressionStrategy;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.INBTSerializable;

public class GunKillData
implements IKillData,
ILockStateChangeable,
INBTSerializable<CompoundNBT> {
    public static final int SKILL_RESET_PRICE = 25;
    private final PlayerEntity player;
    private final IProgressionStrategy strategy;
    private int killCount;
    private int requiredKillCount;
    private int level;
    private int points;

    public GunKillData(PlayerEntity player, GunItem gunItem) {
        this.player = player;
        this.level = 1;
        Object factory = TransactionValidatorRegistry.getValidatorFactory(WeaponTransactionValidator.ID);
        Object validator = TransactionValidatorRegistry.getTransactionValidator(factory, JsonHelper.toSimpleJson(gunItem.getRegistryName()));
        this.strategy = ModUtils.firstNonnull(GunsRPG.getModLifecycle().getProgressionStrategyManager().getStrategy((ITransactionValidator)validator), FakeLevelingStrategy.INSTANCE);
        this.requiredKillCount = this.updateKillRequirement();
    }

    @Override
    public void addLevels(int levels) {
        this.level = Math.min(this.getLevelLimit(), this.level + levels);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void advanceLevel(boolean notify) {
        this.level = Math.min(this.level + 1, this.getLevelLimit());
        this.requiredKillCount = this.updateKillRequirement();
        this.strategy.applyRewards(this.player, this, this.level);
    }

    @Override
    public int getPoints() {
        return this.points;
    }

    @Override
    public void awardPoints(int points) {
        this.points += points;
    }

    @Override
    public void onEnemyKilled(Entity enemy, ItemStack weapon) {
        ++this.killCount;
        if (this.level < this.getLevelLimit() && this.requiredKillCount <= this.killCount) {
            this.killCount = 0;
            this.advanceLevel(false);
            IFormattableTextComponent msg = new TranslationTextComponent("text.weapon.level_up", new Object[]{weapon.func_151000_E().getString()}).func_240699_a_(TextFormatting.GREEN);
            this.player.func_145747_a((ITextComponent)msg, Util.field_240973_b_);
        }
    }

    @Override
    public int getKills() {
        return this.killCount;
    }

    @Override
    public int getRequiredKillCount() {
        return this.requiredKillCount;
    }

    @Override
    public int getLevelLimit() {
        return 9;
    }

    @Override
    public void doUnlock() {
        this.level = this.getLevelLimit();
        this.requiredKillCount = 0;
        this.points = Integer.MAX_VALUE;
    }

    @Override
    public void doLock() {
        this.level = 1;
        this.points = 0;
        this.killCount = 0;
        this.requiredKillCount = this.updateKillRequirement();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("killCount", this.killCount);
        nbt.func_74768_a("requiredKillCount", this.requiredKillCount);
        nbt.func_74768_a("level", this.level);
        nbt.func_74768_a("points", this.points);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.killCount = nbt.func_74762_e("killCount");
        this.requiredKillCount = nbt.func_74762_e("requiredKillCount");
        this.level = Math.max(nbt.func_74762_e("level"), 1);
        this.points = nbt.func_74762_e("points");
    }

    private int updateKillRequirement() {
        return this.strategy.getRequiredKillCount(this.level);
    }
}

